/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MinimizableToolbar
extends HideableToolBar {
    private JComponent fContentContainer;
    private JButton fMinimizeMaximizeButton = new RolloverButton();
    private String fTitle = "";

    public MinimizableToolbar() {
        this.fMinimizeMaximizeButton.setMargin(new Insets(0, 0, 0, 0));
        this.setButtonLabel();
        super.setLayout(new MinimizableToolbarLayout());
        Object gbc = null;
        super.add((Component)this.fMinimizeMaximizeButton, "West");
        super.add((Component)this.getContentContainer(), "Center");
        this.registerListeners();
    }

    public void setLayout(LayoutManager mgr) {
        this.getContentContainer().setLayout(mgr);
    }

    private void registerListeners() {
        this.fMinimizeMaximizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinimizableToolbar.this.setToolbarContentVisible(!MinimizableToolbar.this.isToolbarContentVisible());
            }
        });
    }

    public Component add(Component comp) {
        return this.fContentContainer.add(comp);
    }

    public void add(Component comp, Object constraints) {
        this.fContentContainer.add(comp, constraints);
    }

    public void add(Component comp, Object constraints, int index) {
        this.fContentContainer.add(comp, constraints, index);
    }

    public Component add(String name, Component comp) {
        return this.fContentContainer.add(name, comp);
    }

    public void remove(Component comp) {
        this.fContentContainer.remove(comp);
    }

    public void removeAll() {
        this.fContentContainer.removeAll();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
        this.setButtonLabel();
    }

    private void setButtonLabel() {
        if (this.fContentContainer.isVisible()) {
            this.fMinimizeMaximizeButton.setIcon(Global.getIcon("HideToolbar.gif"));
            this.fMinimizeMaximizeButton.setToolTipText(this.fTitle + " " + Language.getString("minimizableToolbar.hide", "hide"));
        } else {
            this.fMinimizeMaximizeButton.setIcon(Global.getIcon("ShowToolbar.gif"));
            this.fMinimizeMaximizeButton.setToolTipText(this.fTitle + " " + Language.getString("minimizableToolbar.show", "show"));
        }
    }

    public boolean isToolbarContentVisible() {
        return this.fContentContainer.isVisible();
    }

    public void setToolbarContentVisible(boolean contentVisible) {
        this.fContentContainer.setVisible(contentVisible);
        this.setButtonLabel();
    }

    private JComponent getContentContainer() {
        if (this.fContentContainer == null) {
            this.fContentContainer = new JPanel();
            this.fContentContainer.setLayout(new ToolBarLayout(3, 0, 0));
        }
        return this.fContentContainer;
    }

    private static class MinimizableToolbarLayout
    implements LayoutManager {
        private int vgap;
        private int hgap;
        private Component fEast;
        private Component fSouth;
        private Component fNorth;
        private Component fCenter;
        private Component fWest;

        private MinimizableToolbarLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(String name, Component comp) {
            Object object = comp.getTreeLock();
            synchronized (object) {
                if (name == null) {
                    name = "Center";
                }
                if ("Center".equals(name)) {
                    this.fCenter = comp;
                } else if ("North".equals(name)) {
                    this.fNorth = comp;
                } else if ("South".equals(name)) {
                    this.fSouth = comp;
                } else if ("East".equals(name)) {
                    this.fEast = comp;
                } else if ("West".equals(name)) {
                    this.fWest = comp;
                } else {
                    throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension d;
                Insets insets = target.getInsets();
                int top = insets.top;
                int bottom = target.getSize().height - insets.bottom;
                int left = insets.left;
                int right = target.getSize().width - insets.right;
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                Component c = null;
                c = this.fNorth;
                if (c != null) {
                    c.setSize(right - left, c.getSize().height);
                    d = c.getPreferredSize();
                    c.setBounds(left, top, right - left, d.height);
                    top += d.height + this.vgap;
                }
                if ((c = this.fSouth) != null) {
                    c.setSize(right - left, c.getSize().height);
                    d = c.getPreferredSize();
                    c.setBounds(left, bottom - d.height, right - left, d.height);
                    bottom -= d.height + this.vgap;
                }
                if ((c = this.fEast) != null) {
                    c.setSize(c.getSize().width, bottom - top);
                    d = c.getPreferredSize();
                    c.setBounds(right - d.width, top, d.width, bottom - top);
                    right -= d.width + this.hgap;
                }
                if ((c = this.fWest) != null) {
                    c.setSize(c.getSize().width, bottom - top);
                    d = c.getPreferredSize();
                    c.setBounds(left, top, d.width, bottom - top);
                    left += d.width + this.hgap;
                }
                if ((c = this.fCenter) != null) {
                    c.setBounds(left, top, right - left, bottom - top);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension dim = new Dimension(0, 0);
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                Component c = null;
                c = this.fEast;
                if (c != null) {
                    d = c.getMinimumSize();
                    dim.width += d.width + this.hgap;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fWest) != null) {
                    d = c.getMinimumSize();
                    dim.width += d.width + this.hgap;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fCenter) != null && this.fCenter.isVisible()) {
                    d = c.getMinimumSize();
                    dim.width += d.width;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fNorth) != null) {
                    d = c.getMinimumSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height += d.height + this.vgap;
                }
                if ((c = this.fSouth) != null) {
                    d = c.getMinimumSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height += d.height + this.vgap;
                }
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension dim = new Dimension(0, 0);
                Component c = null;
                c = this.fEast;
                if (c != null) {
                    d = c.getPreferredSize();
                    dim.width += d.width + this.hgap;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fWest) != null) {
                    d = c.getPreferredSize();
                    dim.width += d.width + this.hgap;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fCenter) != null && this.fCenter.isVisible()) {
                    c.setSize(target.getSize().width - dim.width, Integer.MAX_VALUE);
                    d = c.getPreferredSize();
                    dim.width += d.width;
                    dim.height = Math.max(d.height, dim.height);
                }
                if ((c = this.fNorth) != null) {
                    d = c.getPreferredSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height += d.height + this.vgap;
                }
                if ((c = this.fSouth) != null) {
                    d = c.getPreferredSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height += d.height + this.vgap;
                }
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                return dim;
            }
        }

        public void removeLayoutComponent(Component comp) {
            if (this.fWest == comp) {
                this.fWest = null;
            }
            if (this.fCenter == comp) {
                this.fCenter = null;
            }
            if (this.fSouth == comp) {
                this.fSouth = null;
            }
            if (this.fNorth == comp) {
                this.fNorth = null;
            }
            if (this.fEast == comp) {
                this.fEast = null;
            }
        }
    }
}

